/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.events.fabric;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.SimpleEvent;

public class MoonlightEventsHelperImpl {
    private static final Map<Class<? extends SimpleEvent>, List<Consumer<? extends SimpleEvent>>> LISTENERS = new IdentityHashMap<Class<? extends SimpleEvent>, List<Consumer<? extends SimpleEvent>>>();

    public static <T extends SimpleEvent> void addListener(Consumer<T> listener, Class<T> eventClass) {
        LISTENERS.computeIfAbsent(eventClass, e -> new ArrayList()).add(listener);
    }

    public static <T extends SimpleEvent> void postEvent(T event, Class<T> eventClass) {
        List<Consumer<? extends SimpleEvent>> consumers = LISTENERS.get(eventClass);
        if (consumers != null) {
            consumers.forEach(e -> e.accept(event));
        }
    }
}

